<?php
include("../dbconn.php");
$con = dbconn();
mysqli_set_charset($con, "utf8mb4");

header('Content-Type: application/json; charset=utf-8');

// Read JSON input
$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

if (!$input) {
    echo json_encode(["success" => "false", "error" => "Invalid JSON"]);
    exit;
}

$action = $input["action"] ?? "";

// Common fields
$com_id      = $input["com_id"] ?? "";
$com_name    = trim($input["com_name"] ?? "");
$com_address = trim($input["com_address"] ?? "");
$contact_no  = trim($input["contact_no"] ?? "");
$email       = trim($input["email"] ?? "");
$create_by   = $input["create_by"] ?? "";
$logo_name   = $input["logo_name"] ?? "";
$logoData    = $input["logoData"] ?? "";
$logo_path   = "../image/company_logo/$logo_name";

$response = [];

switch ($action) {

    // ===========================
    // 🔹 INSERT COMPANY
    // ===========================
    case "insert":
        $con->begin_transaction();
        try {
            // Check duplicate (by company name or email)
            $checkStmt = $con->prepare("SELECT com_id FROM com_info WHERE com_name = ? OR email = ?");
            $checkStmt->bind_param("ss", $com_name, $email);
            $checkStmt->execute();
            $checkStmt->store_result();

            if ($checkStmt->num_rows > 0) {
                echo json_encode(["success" => "duplicate", "message" => "Company already exists."]);
                exit;
            }

            // Insert new company
            $stmt = $con->prepare("
                INSERT INTO com_info (com_id, com_name, com_address, contact_no, email, logo_name, create_by, create_date)
                VALUES (?, ?, ?, ?, ?, ?, ?, NOW())
            ");
            $stmt->bind_param("sssssss", $com_id, $com_name, $com_address, $contact_no, $email, $logo_name, $create_by);
            $stmt->execute();

            // Update user_info com_id
            $stmt2 = $con->prepare("UPDATE user_info SET com_id = ? WHERE user_id = ?");
            $stmt2->bind_param("ss", $com_id, $create_by);
            $stmt2->execute();

            // Save image
            if (!empty($logoData)) {
                file_put_contents($logo_path, base64_decode($logoData));
            }

            $con->commit();
            $response = [
                "success" => "true",
                "action" => "insert",
                "message" => "Company successfully inserted."
            ];
        } catch (Exception $e) {
            $con->rollback();
            $response = ["success" => "false", "error" => $e->getMessage()];
        }
        break;

    // ===========================
    // 🔹 UPDATE COMPANY
    // ===========================
    case "update":
        $con->begin_transaction();
        try {
            // Check if exists
            $checkStmt = $con->prepare("SELECT com_id FROM com_info WHERE com_id = ?");
            $checkStmt->bind_param("s", $com_id);
            $checkStmt->execute();
            $checkStmt->store_result();

            if ($checkStmt->num_rows == 0) {
                echo json_encode(["success" => "false", "message" => "Company not found."]);
                exit;
            }

            // Update company info
            $updateStmt = $con->prepare("
                UPDATE com_info
                SET com_name = ?, com_address = ?, contact_no = ?, email = ?, logo_name = ?, update_by = ?, update_date = NOW()
                WHERE com_id = ?
            ");
            $updateStmt->bind_param("sssssss", $com_name, $com_address, $contact_no, $email, $logo_name, $create_by, $com_id);
            $updateStmt->execute();

            // Update image if provided
            if (!empty($logoData)) {
                file_put_contents($logo_path, base64_decode($logoData));
            }

            $con->commit();
            $response = [
                "success" => "true",
                "action" => "update",
                "message" => "Company successfully updated."
            ];
        } catch (Exception $e) {
            $con->rollback();
            $response = ["success" => "false", "error" => $e->getMessage()];
        }
        break;

    
        
        case 'delete':
    if (!isset($input["com_id"]) || empty($input["com_id"])) {
        echo json_encode(["success" => "false", "msg" => "com_id missing"]);
        exit;
    }

    $com_id = $input["com_id"];

    try {
        // প্রথমে logo_name সংগ্রহ করা হবে
        $stmt_logo = $con->prepare("SELECT logo_name FROM com_info WHERE com_id = ?");
        $stmt_logo->bind_param("s", $com_id);
        $stmt_logo->execute();
        $result_logo = $stmt_logo->get_result();

        if ($result_logo->num_rows > 0) {
            $row = $result_logo->fetch_assoc();
            $logo_name = $row["logo_name"];
            $logo_path = "../image/company_logo/" . $logo_name;

            // এখন রেকর্ড delete করার চেষ্টা
            $stmt = $con->prepare("DELETE FROM com_info WHERE com_id = ?");
            $stmt->bind_param("s", $com_id);
            $stmt->execute();

            if ($stmt->affected_rows > 0) {
                // ✅ রেকর্ড delete সফল হলে তবেই image delete হবে
                if (file_exists($logo_path)) {
                    unlink($logo_path);
                }
                $response = ["success" => "true", "msg" => "company and logo deleted"];
            } else {
                $response = ["success" => "false", "msg" => "record not deleted"];
            }
        } else {
            $response = ["success" => "false", "msg" => "company not found"];
        }

    } catch (Exception $e) {
        $response = ["success" => "false", "msg" => "error: " . $e->getMessage()];
    }

    break;
    
    // ===============================
    // CASE 4: FETCH COMPANY 
    // ===============================
case 'fetchAll':
        try {
            $result = $con->query("SELECT * FROM com_info ORDER BY com_name ASC");
            $data = [];
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            $response = ["success" => "true", "data" => $data];
        } catch (Exception $e) {
            $response = ["success" => "false", "msg" => "error"];
        }
        break;

    // ===============================
    // CASE 5: FETCH COMPANY BY ID
    // ===============================
    case 'fetchByComId':
        if (!isset($input["com_id"]) || empty($input["com_id"])) {
            echo json_encode(["success" => "false", "msg" => "com_id missing"]);
            exit;
        }

        $com_id = $input["com_id"];
        try {
            $stmt = $con->prepare("SELECT * FROM com_info WHERE com_id=?");
            $stmt->bind_param("s", $com_id);
            $stmt->execute();
            $result = $stmt->get_result();
            $data = $result->fetch_assoc();
            if ($data) {
                $response = ["success" => "true", "data" => $data];
            } else {
                $response = ["success" => "false", "msg" => "not found"];
            }
        } catch (Exception $e) {
            $response = ["success" => "false", "msg" => "error"];
        }
        break;


    default:
        $response = ["success" => "false", "msg" => "invalid action"];
        break;
}

echo json_encode($response);
?>