<?php
include("../dbconn.php");
$con = dbconn();

header('Content-Type: application/json');

// Validate inputs
if (!isset($_POST["com_id"]) || !isset($_POST["logo_name"])) {
    echo json_encode(["success" => "false"]);
    exit;
}

$com_id    = $_POST["com_id"];
$logo_name = $_POST["logo_name"];
$logo_path = "../image/company_logo/$logo_name";

$response = [];

try {
    // Delete from com_info using prepared statement
    $stmt = $con->prepare("DELETE FROM com_info WHERE com_id = ?");
    $stmt->bind_param("s", $com_id);

    if ($stmt->execute()) {
        if (file_exists($logo_path)) {
            unlink($logo_path); // Delete logo file
        }
        $response["success"] = "true";
    } else {
        $response["success"] = "false";
    }
} catch (Exception $e) {
    $response["success"] = "false";
}

echo json_encode($response);
?>
