<?php
include("../dbconn.php");
$con = dbconn();

mysqli_set_charset($con, "utf8mb4");

header('Content-Type: application/json; charset=utf-8');

$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

// Required fields
$required_fields = ["com_id", "com_name", "com_address", "contact_no", "email", "create_by", "logo_name", "logoData"];
foreach ($required_fields as $field) {
    if (!isset($_POST[$field])) {
        echo json_encode(["success" => "false"]);
        exit;
    }
}

// Assign variables
$com_id      = $_POST["com_id"];
$com_name    = $_POST["com_name"];
$com_address = $_POST["com_address"];
$contact_no  = $_POST["contact_no"];
$email       = $_POST["email"];
$create_by   = $_POST["create_by"];
$logo_name   = $_POST["logo_name"];
$logoData    = $_POST["logoData"];
$logo_path   = "../image/company_logo/$logo_name";

$response = [];

// Begin transaction
$con->begin_transaction();

try {
    // Insert into com_info
    $stmt1 = $con->prepare("INSERT INTO com_info (com_id, com_name, com_address, contact_no, email, logo_name, create_by) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt1->bind_param("sssssss", $com_id, $com_name, $com_address, $contact_no, $email, $logo_name, $create_by);
    $stmt1->execute();

    // Update user_info set com_id where create_by = ?
    $stmt2 = $con->prepare("UPDATE user_info SET com_id = ? WHERE user_id = ?");
    $stmt2->bind_param("ss", $com_id, $create_by);
    $stmt2->execute();

    // Save logo image
    file_put_contents($logo_path, base64_decode($logoData));

    $con->commit();
    $response["success"] = "true";
} catch (Exception $e) {
    $con->rollback();
    $response["success"] = "false";
}

echo json_encode($response);
?>
