<?php
include("../dbconn.php");
$con = dbconn();

mysqli_set_charset($con, "utf8mb4");
header('Content-Type: application/json; charset=utf-8');
$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

// Required fields
$required_fields = [
    "com_id", "com_name", "com_address", "contact_no", "email", 
    "active", "logo_name", "logo_name_old", "create_by", "logoData"
];

foreach ($required_fields as $field) {
    if (!isset($_POST[$field])) {
        echo json_encode(["success" => "false"]);
        exit;
    }
}

// Assign variables
$com_id        = $_POST["com_id"];
$com_name      = $_POST["com_name"];
$com_address   = $_POST["com_address"];
$contact_no    = $_POST["contact_no"];
$email         = $_POST["email"];
$active        = $_POST["active"]; // This is in your input but was unused
$logo_name     = $_POST["logo_name"];
$logo_name_old = $_POST["logo_name_old"];
$create_by     = $_POST["create_by"];
$logoData      = $_POST["logoData"];

$logo_path     = "../image/company_logo/$logo_name";
$old_logo_path = "../image/company_logo/$logo_name_old";

$response = [];

try {
    // Update com_info with prepared statement
    $stmt = $con->prepare("
        UPDATE com_info 
        SET com_name = ?, com_address = ?, contact_no = ?, email = ?, logo_name = ?, update_by = ?, update_date = NOW() 
        WHERE com_id = ?
    ");
    $stmt->bind_param("sssssss", $com_name, $com_address, $contact_no, $email, $logo_name, $create_by, $com_id);

    if ($stmt->execute()) {
        if (!empty($logoData)) {
            if (file_exists($old_logo_path)) {
                unlink($old_logo_path); // Remove old image
            }
            file_put_contents($logo_path, base64_decode($logoData)); // Save new image
        }
        $response["success"] = "true";
    } else {
        $response["success"] = "false";
    }
} catch (Exception $e) {
    $response["success"] = "false";
}

echo json_encode($response);
?>
