<?php
include("../dbconn.php");
$con = dbconn();
mysqli_set_charset($con, "utf8mb4");

header('Content-Type: application/json; charset=utf-8');

$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

$action = $input['action'] ?? "";
$com_id = $input['com_id'] ?? "";

switch ($action) {

    // =================== FETCH ALL ===================
    case 'fetchAll':
        $stmt = $con->prepare("SELECT * FROM delivary_charge WHERE com_id=?");
        $stmt->bind_param("s", $com_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $data = [];
        while ($row = $result->fetch_assoc()) {
            $row['district_id'] = intval($row['district_id']);
            $row['active'] = intval($row['active']);
            $data[] = $row;
        }
        echo json_encode($data);
        break;
        // =================== FETCH ALL BY ACTIVE ===================
    case 'fetchByActive':
        $stmt = $con->prepare("SELECT * FROM delivary_charge WHERE com_id=? AND active=1");
        $stmt->bind_param("s", $com_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $data = [];
        while ($row = $result->fetch_assoc()) {
            $row['district_id'] = intval($row['district_id']);
            $row['active'] = intval($row['active']);
            $data[] = $row;
        }
        echo json_encode($data);
        break;

    // =================== FETCH BY DISTRICT ID ===================
    case 'fetchByDistrictId':
        $district_id = intval($input['district_id'] ?? 0);
        $stmt = $con->prepare("SELECT * FROM delivary_charge WHERE district_id=? AND com_id=?");
        $stmt->bind_param("is", $district_id, $com_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $data = [];
        while ($row = $result->fetch_assoc()) {
            $row['district_id'] = intval($row['district_id']);
            $row['active'] = intval($row['active']);
            $data[] = $row;
        }
        echo json_encode($data);
        break;

    // =================== ADD ===================
    case 'add':
        $com_id = $input['com_id'] ?? "";
        $district_name = $input['district_name'] ?? "";
        $charge_am = floatval($input['charge_am'] ?? 0);
        $active = intval($input['active'] ?? 1);

        // Duplicate check
        $stmtCheck = $con->prepare("SELECT * FROM delivary_charge WHERE district_name=? AND com_id=?");
        $stmtCheck->bind_param("ss", $district_name, $com_id);
        $stmtCheck->execute();
        $resultCheck = $stmtCheck->get_result();
        if ($resultCheck->num_rows > 0) {
            echo json_encode(["success" => "duplicate"]);
            exit;
        }

        $stmt = $con->prepare("INSERT INTO delivary_charge (com_id, district_name, charge_am, active) VALUES (?,?,?,?)");
        $stmt->bind_param("ssdi", $com_id, $district_name, $charge_am, $active);
        $success = $stmt->execute();
        echo json_encode(["success" => $success ? "true" : "false"]);
        break;
        
        // =================== Insert All ===================
    case 'insertAll':
        $com_id = $input['com_id'] ?? "";
        $charge_am = floatval($input['charge_am'] ?? 0);
        $active = intval($input['active'] ?? 1);

        // Default district list (Bangladesh)
        $districts = [
    "Bagerhat", "Bandarban", "Barguna", "Barisal", "Bhola", "Bogra", "Brahmanbaria",
    "Chandpur", "Chattogram", "Chuadanga", "Comilla", "Cox's Bazar", "Dhaka", "Dinajpur",
    "Faridpur", "Feni", "Gaibandha", "Gazipur", "Gopalganj", "Habiganj", "Jamalpur",
    "Jashore", "Jhalokati", "Jhenaidah", "Joypurhat", "Khagrachari", "Khulna", "Kishoreganj",
    "Kurigram", "Kushtia", "Lakshmipur", "Lalmonirhat", "Madaripur", "Magura", "Manikganj",
    "Meherpur", "Moulvibazar", "Munshiganj", "Mymensingh", "Naogaon", "Narail", "Narsingdi",
    "Natore", "Netrokona", "Nilphamari", "Noakhali", "Pabna", "Panchagarh", "Patuakhali",
    "Pirojpur", "Rajbari", "Rajshahi", "Rangamati", "Rangpur", "Satkhira", "Shariatpur",
    "Sherpur", "Sirajganj", "Sunamganj", "Sylhet", "Tangail", "Thakurgaon"
];


        $updatedCount = 0;

        foreach ($districts as $district_name) {
            // Check if district exists for this com_id
            $stmtCheck = $con->prepare("SELECT district_id FROM delivary_charge WHERE com_id=? AND district_name=?");
            $stmtCheck->bind_param("ss", $com_id, $district_name);
            $stmtCheck->execute();
            $resultCheck = $stmtCheck->get_result();

            if ($resultCheck->num_rows > 0) {
                // Update existing
                $row = $resultCheck->fetch_assoc();
                $district_id = intval($row['district_id']);

                $stmt = $con->prepare("UPDATE delivary_charge SET charge_am=?, active=? WHERE district_id=?");
                $stmt->bind_param("dii", $charge_am, $active, $district_id);
                if($stmt->execute()) $updatedCount++;
            } else {
                // Insert new
                $stmt = $con->prepare("INSERT INTO delivary_charge (com_id, district_name, charge_am, active) VALUES (?,?,?,?)");
                $stmt->bind_param("ssdi", $com_id, $district_name, $charge_am, $active);
                if($stmt->execute()) $updatedCount++;
            }
        }

        echo json_encode([
            "success" => "true",
            "updated_records" => $updatedCount
        ]);
        break;


    // =================== UPDATE ===================
case 'update':
    $com_id = $input['com_id'] ?? "";
    $district_id = intval($input['district_id'] ?? 0);
    $district_name = $input['district_name'] ?? "";
    $charge_am = floatval($input['charge_am'] ?? 0);
    $active = intval($input['active'] ?? 1);

    // Duplicate check excluding current record
    $stmtCheck = $con->prepare("SELECT * FROM delivary_charge WHERE district_name=? AND com_id=? AND district_id<>?");
    $stmtCheck->bind_param("ssi", $district_name, $com_id, $district_id);
    $stmtCheck->execute();
    $resultCheck = $stmtCheck->get_result();
    if ($resultCheck->num_rows > 0) {
        echo json_encode(["success" => "duplicate"]);
        exit;
    }

    $stmt = $con->prepare("UPDATE delivary_charge SET district_name=?, charge_am=?, active=? WHERE district_id=?");
    $stmt->bind_param("sdii", $district_name, $charge_am, $active, $district_id);
    $success = $stmt->execute();
    echo json_encode(["success" => $success ? "true" : "false"]);
    break;


    // =================== DELETE ===================
    case 'delete':
        $district_id = intval($input['district_id'] ?? 0);
        $stmt = $con->prepare("DELETE FROM delivary_charge WHERE district_id=?");
        $stmt->bind_param("i", $district_id);
        $success = $stmt->execute();
        echo json_encode(["success" => $success ? "true" : "false"]);
        break;

    default:
        echo json_encode(["error" => "Invalid action"]);
}
?>
