<?php
include("../dbconn.php");
$con = dbconn();
header('Content-Type: application/json');

// Required fields check
$required_fields = ["com_id", "employee_id", "employee_image"];
foreach ($required_fields as $field) {
    if (!isset($_POST[$field])) {
        echo json_encode(["success" => "false", "message" => "$field is missing"]);
        exit;
    }
}

// Assign variables
$com_id         = $_POST["com_id"];
$employee_id    = $_POST["employee_id"];
$employee_image = $_POST["employee_image"];
$image_path     = "../image/employee_image/$employee_image";

// Prepare and execute delete query
$stmt = $con->prepare("DELETE FROM employee_info WHERE com_id = ? AND employee_id = ?");
$stmt->bind_param("ss", $com_id, $employee_id);

$response = [];

if ($stmt->execute()) {
    if ($employee_image !== "noImage.jpg" && file_exists($image_path)) {
        unlink($image_path);
    }
    $response["success"] = "true";
} else {
    $response["success"] = "false";
    $response["message"] = $stmt->error;
}

echo json_encode($response);
?>
