<?php

include("../dbconn.php");
$con = dbconn();

// Set content type
header('Content-Type: application/json');

// Check required fields
if (!isset($_POST["com_id"], $_POST["employee_name"])) {
    echo json_encode(["success" => "false", "error" => "Missing required parameters."]);
    exit;
}

$com_id = $_POST["com_id"];
$employee_name = $_POST["employee_name"];

// Use prepared statement to prevent SQL injection
$stmt = $con->prepare("SELECT * FROM employee_info WHERE com_id = ? AND employee_name = ?");
$stmt->bind_param("ss", $com_id, $employee_name);

$response = [];

if ($stmt->execute()) {
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $response[] = $row;
    }
    echo json_encode($response);
} else {
    echo json_encode([
        "success" => "false",
        "error" => $stmt->error
    ]);
}

$stmt->close();
?>
