<?php

include("../dbconn.php");
$con = dbconn();

// Set response content type
header('Content-Type: application/json');

// Check if com_id is provided
if (!isset($_POST["com_id"])) {
    echo json_encode(["success" => "false", "error" => "com_id required"]);
    exit;
}

$com_id = $_POST["com_id"];

// Use prepared statement with explicit JOIN
$sql = "
    SELECT 
        a.*, 
        b.position_name 
    FROM 
        employee_info a
    JOIN 
        employee_position b ON a.employee_position_id = b.position_id
    WHERE 
        a.com_id = ?
    ORDER BY 
        a.employee_name
";

$stmt = $con->prepare($sql);
$stmt->bind_param("s", $com_id);

$response = [];

if ($stmt->execute()) {
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $response[] = $row;
    }
    echo json_encode($response);
} else {
    echo json_encode(["success" => "false", "error" => $stmt->error]);
}

$stmt->close();
?>
