<?php
include("../dbconn.php");
$con = dbconn();

header('Content-Type: application/json');

// Required fields
$required_fields = [
    "com_id", "employee_name", "employee_position_id", "employee_father_name",
    "employee_address", "employee_nid", "employee_email", "employee_contact_no",
    "employee_joining_date", "blood_group", "max_qualification",
    "employee_image", "employee_id", "create_by", "imageData"
];

// Check for missing fields
foreach ($required_fields as $field) {
    if (!isset($_POST[$field])) {
        echo json_encode(["success" => "false", "message" => "$field is missing"]);
        exit;
    }
}

// Assign variables
$com_id                = $_POST["com_id"];
$employee_name         = $_POST["employee_name"];
$employee_position_id  = $_POST["employee_position_id"];
$employee_father_name  = $_POST["employee_father_name"];
$employee_address      = $_POST["employee_address"];
$employee_nid          = $_POST["employee_nid"];
$employee_email        = $_POST["employee_email"];
$employee_contact_no   = $_POST["employee_contact_no"];
$employee_joining_date = $_POST["employee_joining_date"];
$blood_group           = $_POST["blood_group"];
$max_qualification     = $_POST["max_qualification"];
$employee_image        = $_POST["employee_image"];
$employee_id           = $_POST["employee_id"];
$create_by             = $_POST["create_by"];
$imageData             = $_POST["imageData"];

$path = "../image/employee_image/$employee_image";

// Prepare and bind
$stmt = $con->prepare("
    INSERT INTO employee_info (
        com_id, employee_position_id, employee_name, employee_father_name,
        employee_address, employee_nid, employee_contact_no, employee_email,
        employee_joining_date, blood_group, max_qualification,
        employee_image, employee_id, create_by
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");

$stmt->bind_param(
    "ssssssssssssss",
    $com_id, $employee_position_id, $employee_name, $employee_father_name,
    $employee_address, $employee_nid, $employee_contact_no, $employee_email,
    $employee_joining_date, $blood_group, $max_qualification,
    $employee_image, $employee_id, $create_by
);

$response = [];

if ($stmt->execute()) {
    // Save image only if not empty
    if (!empty($imageData)) {
        file_put_contents($path, base64_decode($imageData));
    }
    $response["success"] = "true";
} else {
    $response["success"] = "false";
    $response["message"] = $stmt->error;
}

echo json_encode($response);
?>
