<?php
include("../dbconn.php");
$con = dbconn();
header('Content-Type: application/json');

// Required fields
$required_fields = [
    "com_id", "employee_name", "employee_father_name", "employee_address",
    "employee_nid", "employee_contact_no", "employee_joining_date",
    "blood_group", "max_qualification", "employee_image", "employee_id",
    "update_by", "imageData", "employee_image_old"
];

foreach ($required_fields as $field) {
    if (!isset($_POST[$field])) {
        echo json_encode(["success" => "false", "message" => "$field is missing"]);
        exit;
    }
}

// Optional field
$employee_email = isset($_POST["employee_email"]) ? $_POST["employee_email"] : "";

// Assign variables
$com_id               = $_POST["com_id"];
$employee_name        = $_POST["employee_name"];
$employee_father_name = $_POST["employee_father_name"];
$employee_address     = $_POST["employee_address"];
$employee_nid         = $_POST["employee_nid"];
$employee_contact_no  = $_POST["employee_contact_no"];
$employee_joining_date= $_POST["employee_joining_date"];
$blood_group          = $_POST["blood_group"];
$max_qualification    = $_POST["max_qualification"];
$employee_image       = $_POST["employee_image"];
$employee_id          = $_POST["employee_id"];
$update_by            = $_POST["update_by"];
$imageData            = $_POST["imageData"];
$employee_image_old   = $_POST["employee_image_old"];

$path     = "../image/employee_image/$employee_image";
$oldPath  = "../image/employee_image/$employee_image_old";

// Prepare and bind SQL update
$stmt = $con->prepare("
    UPDATE employee_info 
    SET employee_name=?, employee_father_name=?, employee_address=?, 
        employee_nid=?, employee_contact_no=?, employee_email=?, 
        employee_joining_date=?, blood_group=?, max_qualification=?, 
        employee_image=?, update_date=NOW(), update_by=?
    WHERE com_id=? AND employee_id=?
");

$stmt->bind_param(
    "sssssssssssss",
    $employee_name, $employee_father_name, $employee_address,
    $employee_nid, $employee_contact_no, $employee_email,
    $employee_joining_date, $blood_group, $max_qualification,
    $employee_image, $update_by, $com_id, $employee_id
);

// Execute and respond
$response = [];

if ($stmt->execute()) {
    // Handle image update
    if (!empty($imageData)) {
        if ($employee_image_old !== "noImage.jpg" && file_exists($oldPath)) {
            unlink($oldPath);
        }
        file_put_contents($path, base64_decode($imageData));
    }

    $response["success"] = "true";
} else {
    $response["success"] = "false";
    $response["message"] = $stmt->error;
}

echo json_encode($response);
?>
