<?php
include("../dbconn.php");
$con = dbconn();
mysqli_set_charset($con, "utf8mb4");

header('Content-Type: application/json; charset=utf-8');

$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);
$action = $input['action'] ?? "";

switch ($action) {

    // =================== FETCH ALL ===================
    case 'fetchAll':
        $result = $con->query("SELECT * FROM item_color");
        $data = [];
        while ($row = $result->fetch_assoc()) {
            $row['item_color_id'] = intval($row['item_color_id']);
            $row['active'] = intval($row['active']);
            $data[] = $row;
        }
        echo json_encode($data);
        break;

    // =================== FETCH BY ITEM ID ===================
    case 'fetchByItemId':
        $item_id = $input['item_id'] ?? "";
        $stmt = $con->prepare("SELECT * FROM item_color WHERE item_id=?");
        $stmt->bind_param("s", $item_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $data = [];
        while ($row = $result->fetch_assoc()) {
            $row['item_color_id'] = intval($row['item_color_id']);
            $row['active'] = intval($row['active']);
            $data[] = $row;
        }
        echo json_encode($data);
        break;

    // =================== ADD ===================
    case 'add':
        $com_id = $input['com_id'] ?? "";
        $item_id = $input['item_id'] ?? "";
        $color_name = $input['color_name'] ?? "";
        $image_name = $input['image_name'] ?? "";
        $imageData = $input["imageData"];
        $active = intval($input['active'] ?? 1);

        // Duplicate check
        $stmtCheck = $con->prepare("SELECT * FROM item_color WHERE com_id=? AND item_id=? AND color_name=?");
        $stmtCheck->bind_param("sss", $com_id, $item_id, $color_name);
        $stmtCheck->execute();
        $resultCheck = $stmtCheck->get_result();
        if ($resultCheck->num_rows > 0) {
            echo json_encode(["success" => "duplicate"]);
            exit;
        }
        // Image handling
    if (!empty($imageData)) {
        
       // $image_name = $item_id . "_" . $item_color . "." . $imageExt;
        $path = "../image/item_image/" . $image_name;
    }
        $stmt = $con->prepare("INSERT INTO item_color (com_id, item_id, color_name,image_name, active) VALUES (?,?,?,?,?)");
        $stmt->bind_param("ssssi", $com_id, $item_id, $color_name,$image_name, $active);
        

    if ($stmt->execute()) {
        if (!empty($imageData)) {
            file_put_contents($path, base64_decode($imageData));
        }
        $response["success"] = "true";
        $response["item_id"] = $item_id;
        $response["image_name"] = $image_name;
    } else {
        $response["success"] = "false";
        $response["error"] = $stmt->error;
    }

    echo json_encode($response);
    $stmt->close();
    $checkStmt->close();
       // echo json_encode(["success" => $success ? "true" : "false"]);
    break;

    // =================== UPDATE ===================
    case 'update':
    $id = intval($input['item_color_id'] ?? 0);
    $com_id = $input['com_id'] ?? "";
    $item_id = $input['item_id'] ?? "";
    $color_name = $input['color_name'] ?? "";
    $image_name = $input['image_name'] ?? "";
    $image_name_old = $input['image_name_old'] ?? "";
    $imageData = $input['imageData'] ?? "";
    $active = intval($input['active'] ?? 1);
    $path = "../image/item_image/" . $image_name;
    $oldPath = "../image/item_image/" . $image_name_old;

    // 🔹 Duplicate check excluding current row
    $stmtCheck = $con->prepare("SELECT 1 FROM item_color WHERE com_id=? AND item_id=? AND color_name=? AND item_color_id<>?");
    $stmtCheck->bind_param("sssi", $com_id, $item_id, $color_name, $id);
    $stmtCheck->execute();
    $resultCheck = $stmtCheck->get_result();

    if ($resultCheck->num_rows > 0) {
        echo json_encode(["success" => "duplicate"]);
        $stmtCheck->close();
        break; // 🔹 stop further execution immediately
    }
    $stmtCheck->close();

    // 🔹 Update main record
    $stmt = $con->prepare("UPDATE item_color SET com_id=?, item_id=?, color_name=?, image_name=?, active=? WHERE item_color_id=?");
    $stmt->bind_param("ssssii", $com_id, $item_id, $color_name, $image_name, $active, $id);

    if ($stmt->execute()) {
        // 🔹 Image handling
        if (!empty($imageData)) {
            if ($image_name_old == "noImage.jpg") {
                file_put_contents($path, base64_decode($imageData));
            } else {
                if (file_exists($oldPath)) unlink($oldPath);
                file_put_contents($path, base64_decode($imageData));
            }
        }

        $response = [
            "success" => "true",
            "item_id" => $item_id,
            "image_name" => $image_name
        ];
    } else {
        $response = [
            "success" => "false",
            "error" => $stmt->error
        ];
    }

    echo json_encode($response);
    $stmt->close();
    break;



    // =================== DELETE ===================
    case 'delete':
        $id = intval($input['item_color_id'] ?? 0);
                $image_name = $input['image_name'] ?? "";
        $stmt = $con->prepare("DELETE FROM item_color WHERE item_color_id=?");
        $stmt->bind_param("i", $id);
               if ($stmt->execute()) {
            // Delete image if exists
            
            if (!empty($image_name)) {
                if($image_name !='noImage.jpg'){
                     $path = "../image/item_image/" . $image_name;
                if (file_exists($path)) {
                    unlink($path);
                }
                }
               
            }
            echo json_encode(["success" => "true"]);
        } else {
            echo json_encode(["success" => "false", "error" => $stmt->error]);
        }

        $stmt->close();
        break;

    // =================== INVALID ACTION ===================
    default:
        echo json_encode(["error" => "Invalid action"]);
}
?>
