<?php
include("../dbconn.php");
$con = dbconn();
mysqli_set_charset($con, "utf8mb4");
header('Content-Type: application/json; charset=utf-8');

// Read JSON body (if any)
$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

// Prefer JSON values, fallback to $_POST
$com_id = $input['com_id'] ?? $_POST['com_id'] ?? null;
$item_name = $input['item_name'] ?? $_POST['item_name'] ?? null;

if ($com_id === null || $item_name === null) {
    echo json_encode(["success" => false, "error" => "Required fields missing"]);
    exit;
}

// Prepared statement to avoid injection
$stmt = $con->prepare("SELECT COUNT(*) AS cnt FROM item_details WHERE com_id = ? AND item_name = ?");
$stmt->bind_param("ss", $com_id, $item_name);
$stmt->execute();
$res = $stmt->get_result();
$row = $res->fetch_assoc();
$count = intval($row['cnt'] ?? 0);

$stmt->close();

echo json_encode([
    "success" => true,
    "duplicate" => $count > 0,
    "count" => $count
]);
?>
