<?php
include("../dbconn.php");
$con = dbconn();
header('Content-Type: application/json');

// GET বা POST যেভাবেই আসুক, আগে নাও
$com_id = $_POST["com_id"] ?? ($_GET["com_id"] ?? null);

if ($com_id === null) {
    echo json_encode(["success" => false, "error" => "com_id is required"]);
    exit;
}

// ✅ Proper prepared statement with placeholder
$stmt = $con->prepare("
    SELECT a.*, b.category_name 
    FROM item_details a
    JOIN item_category b ON a.category_id = b.category_id
    WHERE a.com_id = ?
    ORDER BY a.item_name
");

if ($stmt === false) {
    echo json_encode(["success" => false, "error" => $con->error]);
    exit;
}

$stmt->bind_param("s", $com_id);
$stmt->execute();
$result = $stmt->get_result();

$items = [];
while ($row = $result->fetch_assoc()) {
    $items[] = $row;
}

echo json_encode($items, JSON_UNESCAPED_UNICODE);

$stmt->close();
$con->close();
?>
