<?php

include("../dbconn.php");
$con = dbconn();

mysqli_set_charset($con, "utf8mb4");

header('Content-Type: application/json; charset=utf-8');

$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

// Collect required fields
$fields = [
    "com_id", "item_name", "category_id", "item_brand", "item_model",
    "item_size","item_color", "item_unit", "item_cost", "item_trading_price",
    "item_barcode", "item_flag", "item_id", "create_by", "image_name", "imageData"
];

$data = [];
foreach ($fields as $field) {
    if (!isset($_POST[$field])) {
        echo json_encode(["success" => "false", "error" => "$field is required"]);
        exit;
    }
    $data[$field] = $_POST[$field];
}

$path = "../image/item_image/" . $data["image_name"];

// Prepare SQL statement to prevent SQL injection
$stmt = $con->prepare("
    INSERT INTO item_details (
        com_id, category_id, item_name, item_brand, item_model,
        item_size,item_color, item_unit, item_cost, item_trading_price,
        item_barcode, item_flag, image_name, item_id, create_by
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)
");

$stmt->bind_param(
    "ssssssssddsssss",
    $data["com_id"],
    $data["category_id"],
    $data["item_name"],
    $data["item_brand"],
    $data["item_model"],
    $data["item_size"],
    $data["item_color"],
    $data["item_unit"],
    $data["item_cost"],
    $data["item_trading_price"],
    $data["item_barcode"],
    $data["item_flag"],
    $data["image_name"],
    $data["item_id"],
    $data["create_by"]
);

$response = [];

if ($stmt->execute()) {
    if (!empty($data["imageData"])) {
        file_put_contents($path, base64_decode($data["imageData"]));
    }
    $response["success"] = "true";
} else {
    $response["success"] = "false";
    $response["error"] = $stmt->error;
}

echo json_encode($response);
$stmt->close();
?>
