<?php

include("../dbconn.php");
$con = dbconn();
header('Content-Type: application/json');

// প্রয়োজনীয় ইনপুট সংগ্রহ
$fields = [
    "com_id", "item_name", "item_brand", "item_model", "item_size","item_color",
    "item_unit", "item_cost", "item_trading_price", "item_barcode",
    "item_flag", "item_id", "update_by", "image_name", "image_name_old", "imageData"
];

$data = [];
foreach ($fields as $field) {
    if (!isset($_POST[$field])) {
        echo json_encode(["success" => "false", "error" => "$field is required"]);
        exit;
    }
    $data[$field] = $_POST[$field];
}

$path = "../image/item_image/" . $data["image_name"];
$oldPath = "../image/item_image/" . $data["image_name_old"];

// Prepare statement for safe SQL execution
$stmt = $con->prepare("
    UPDATE item_details 
    SET item_name = ?, item_brand = ?, item_model = ?, item_size = ?,item_color = ?, item_unit = ?, 
        item_cost = ?, item_trading_price = ?, item_barcode = ?, item_flag = ?, 
        image_name = ?, update_date = NOW(), update_by = ?
    WHERE com_id = ? AND item_id = ?
");

$stmt->bind_param(
    "ssssssddsssss",
    $data["item_name"],
    $data["item_brand"],
    $data["item_model"],
    $data["item_size"],
    $data["item_color"],
    $data["item_unit"],
    $data["item_cost"],
    $data["item_trading_price"],
    $data["item_barcode"],
    $data["item_flag"],
    $data["image_name"],
    $data["update_by"],
    $data["com_id"],
    $data["item_id"]
);

$response = [];

if ($stmt->execute()) {
    if (!empty($data["imageData"])) {
        // পুরনো ছবি মুছুন (যদি এটি noImage.jpg না হয় এবং ফাইলটি বিদ্যমান থাকে)
        if ($data["image_name_old"] != "noImage.jpg" && file_exists($oldPath)) {
            unlink($oldPath);
        }
        file_put_contents($path, base64_decode($data["imageData"]));
    }
    $response["success"] = "true";
} else {
    $response["success"] = "false";
    $response["error"] = $stmt->error;
}

echo json_encode($response);
$stmt->close();
?>
