<?php
include("../dbconn.php");
$con = dbconn();
header('Content-Type: application/json');

// ============================
// 1. Required field validation
// ============================
if (!isset($_POST['feature_id']) || empty($_POST['feature_id'])) {
    echo json_encode(["success" => "false", "error" => "feature_id is required"]);
    exit;
}

$feature_id = trim($_POST['feature_id']);

// ============================
// 2. Delete query
// ============================
$delete_sql = "DELETE FROM item_features WHERE feature_id = ?";
$delete_stmt = $con->prepare($delete_sql);
$delete_stmt->bind_param("i", $feature_id); // assuming feature_id is INT

if ($delete_stmt->execute()) {
    echo json_encode(["success" => "true"]);
} else {
    echo json_encode(["success" => "false", "error" => $delete_stmt->error]);
}

$delete_stmt->close();
$con->close();
?>
