<?php
include("../dbconn.php");
$con = dbconn();
// নিশ্চিত করো যে connection utf8mb4 ব্যবহার করছে
mysqli_set_charset($con, "utf8mb4");

// JSON response header
header('Content-Type: application/json; charset=utf-8');

// GET বা POST যেভাবেই আসুক, আগে নাও
$item_id = $_POST["item_id"] ?? ($_GET["item_id"] ?? null);

if ($item_id === null) {
    echo json_encode(["success" => false, "error" => "item_id is required"]);
    exit;
}

// ✅ Proper prepared statement with placeholder
$stmt = $con->prepare("
    SELECT * FROM item_features  WHERE item_id = ?
    ORDER BY feature_id
");

if ($stmt === false) {
    echo json_encode(["success" => false, "error" => $con->error]);
    exit;
}

$stmt->bind_param("s", $item_id);
$stmt->execute();
$result = $stmt->get_result();

$items = [];
while ($row = $result->fetch_assoc()) {
    $items[] = $row;
}

echo json_encode($items, JSON_UNESCAPED_UNICODE);

$stmt->close();
$con->close();
?>
