<?php
include("../dbconn.php");
$con = dbconn();
mysqli_set_charset($con, "utf8mb4"); // Connection charset

header('Content-Type: application/json; charset=utf-8');

// Get POSTed JSON data
$input = json_decode(file_get_contents("php://input"), true);
if (!$input) {
    http_response_code(400);
    echo json_encode(["success" => false, "message" => "Invalid JSON"]);
    exit();
}

// Validate required fields
$required = ["com_id", "item_id", "feature_text", "create_by"];
foreach ($required as $field) {
    if (empty($input[$field])) {
        http_response_code(400);
        echo json_encode(["success" => false, "message" => "$field is required"]);
        exit();
    }
}

// Correct variable assignment
$com_id = $input["com_id"];
$item_id = $input["item_id"];
$feature_text = $input["feature_text"];
$create_by = $input["create_by"];

// ===========================
// 1. Duplicate check
// ===========================
$check_stmt = $con->prepare("
    SELECT feature_id 
    FROM item_features 
    WHERE item_id = ? AND feature_text = ?
");
$check_stmt->bind_param("ss", $item_id, $feature_text);
$check_stmt->execute();
$check_result = $check_stmt->get_result();

if ($check_result->num_rows > 0) {
    echo json_encode(["success" => "duplicate"]);
    $check_stmt->close();
    $con->close();
    exit();
}
$check_stmt->close();

// ===========================
// 2. Insert if no duplicate
// ===========================
$insert_stmt = $con->prepare("
    INSERT INTO item_features (com_id, item_id, feature_text, create_by)
    VALUES (?, ?, ?, ?)
");
$insert_stmt->bind_param("ssss", $com_id, $item_id, $feature_text, $create_by);

if ($insert_stmt->execute()) {
    echo json_encode(["success" => "true"]);
} else {
    echo json_encode(["success" => "false", "error" => $insert_stmt->error]);
}

$insert_stmt->close();
$con->close();
?>
