<?php
include("../dbconn.php");
$con = dbconn();
mysqli_set_charset($con, "utf8mb4");

header('Content-Type: application/json; charset=utf-8');

// JSON POST body নেওয়া
$input = json_decode(file_get_contents("php://input"), true);

if (!$input) {
    http_response_code(400);
    echo json_encode(["success" => false, "error" => "Invalid JSON"]);
    exit;
}

// Required fields validation
$fields = ["feature_id", "item_id", "feature_text", "update_by"];
foreach ($fields as $field) {
    if (!isset($input[$field]) || $input[$field] === "") {
        echo json_encode(["success" => "false", "error" => "$field is required"]);
        exit;
    }
}

$feature_id = $input["feature_id"];
$item_id = $input["item_id"];
$feature_text = $input["feature_text"];
$update_by = $input["update_by"];

// Duplicate check
$check_sql = "SELECT feature_id FROM item_features WHERE item_id = ? AND feature_text = ? AND feature_id != ?";
$check_stmt = $con->prepare($check_sql);
$check_stmt->bind_param("ssi", $item_id, $feature_text, $feature_id);
$check_stmt->execute();
$check_result = $check_stmt->get_result();

if ($check_result->num_rows > 0) {
    echo json_encode(["success" => "duplicate"]);
    $check_stmt->close();
    $con->close();
    exit;
}
$check_stmt->close();

// Update query
$update_sql = "UPDATE item_features SET feature_text = ?, update_by = ?, update_date = NOW() WHERE feature_id = ?";
$update_stmt = $con->prepare($update_sql);
$update_stmt->bind_param("ssi", $feature_text, $update_by, $feature_id);

if ($update_stmt->execute()) {
    echo json_encode(["success" => "true"]);
} else {
    echo json_encode(["success" => "false", "error" => $update_stmt->error]);
}

$update_stmt->close();
$con->close();
?>
