<?php
include("../dbconn.php");
$con = dbconn();
mysqli_set_charset($con, "utf8mb4");

header('Content-Type: application/json; charset=utf-8');

$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);
$action = $input['action'] ?? "";

switch ($action) {

    // =================== FETCH ALL ===================
    case 'fetchAll':
        $result = $con->query("SELECT * FROM item_size");
        $data = [];
        while ($row = $result->fetch_assoc()) {
            $row['item_size_id'] = intval($row['item_size_id']);
            $row['active'] = intval($row['active']);
            $data[] = $row;
        }
        echo json_encode($data);
        break;

    // =================== FETCH BY ITEM ID ===================
    case 'fetchByItemId':
        $item_id = $input['item_id'] ?? "";
        $stmt = $con->prepare("SELECT * FROM item_size WHERE item_id=?");
        $stmt->bind_param("s", $item_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $data = [];
        while ($row = $result->fetch_assoc()) {
            $row['item_size_id'] = intval($row['item_size_id']);
            $row['active'] = intval($row['active']);
            $data[] = $row;
        }
        echo json_encode($data);
        break;

    // =================== ADD ===================
    case 'add':
        $com_id = $input['com_id'] ?? "";
        $item_id = $input['item_id'] ?? "";
        $size_name = $input['size_name'] ?? "";
        $active = intval($input['active'] ?? 1);

        // Duplicate check
        $stmtCheck = $con->prepare("SELECT * FROM item_size WHERE com_id=? AND item_id=? AND size_name=?");
        $stmtCheck->bind_param("sss", $com_id, $item_id, $size_name);
        $stmtCheck->execute();
        $resultCheck = $stmtCheck->get_result();
        if ($resultCheck->num_rows > 0) {
            echo json_encode(["success" => "duplicate"]);
            exit;
        }

        $stmt = $con->prepare("INSERT INTO item_size (com_id, item_id, size_name, active) VALUES (?,?,?,?)");
        $stmt->bind_param("sssi", $com_id, $item_id, $size_name, $active);
        $success = $stmt->execute();
        echo json_encode(["success" => $success ? "true" : "false"]);
        break;

    // =================== UPDATE ===================
    case 'update':
        $id = intval($input['item_size_id'] ?? 0);
        $com_id = $input['com_id'] ?? "";
        $item_id = $input['item_id'] ?? "";
        $size_name = $input['size_name'] ?? "";
        $active = intval($input['active'] ?? 1);

        // Duplicate check excluding current row
        $stmtCheck = $con->prepare("SELECT * FROM item_size WHERE com_id=? AND item_id=? AND size_name=? AND item_size_id<>?");
        $stmtCheck->bind_param("sssi", $com_id, $item_id, $size_name, $id);
        $stmtCheck->execute();
        $resultCheck = $stmtCheck->get_result();
        if ($resultCheck->num_rows > 0) {
            echo json_encode(["success" => "duplicate"]);
            exit;
        }

        $stmt = $con->prepare("UPDATE item_size SET com_id=?, item_id=?, size_name=?, active=? WHERE item_size_id=?");
        $stmt->bind_param("sssii", $com_id, $item_id, $size_name, $active, $id);
        $success = $stmt->execute();
        echo json_encode(["success" => $success ? "true" : "false"]);
        break;

    // =================== DELETE ===================
    case 'delete':
        $id = intval($input['item_size_id'] ?? 0);
        $stmt = $con->prepare("DELETE FROM item_size WHERE item_size_id=?");
        $stmt->bind_param("i", $id);
        $success = $stmt->execute();
        echo json_encode(["success" => $success ? "true" : "false"]);
        break;

    // =================== INVALID ACTION ===================
    default:
        echo json_encode(["error" => "Invalid action"]);
}
?>
