<?php
include("../dbconn.php");
$con = dbconn();
mysqli_set_charset($con, "utf8mb4"); // UTF-8 charset set

header('Content-Type: application/json; charset=utf-8');

// ===============================
// 1. Get JSON Data from Flutter
// ===============================
$input = json_decode(file_get_contents("php://input"), true);

// Check if JSON is valid
if (!$input) {
    http_response_code(400);
    echo json_encode(["success" => false, "message" => "Invalid JSON"]);
    exit();
}

// ===============================
// 2. Validate Required Fields
// ===============================
$required = [
    "com_id", "item_id", "offer_title", "start_time", "end_time",
    "discount_price", "reg_price", "status", "create_by"
];
foreach ($required as $field) {
    if (!isset($input[$field]) || $input[$field] === "") {
        http_response_code(400);
        echo json_encode(["success" => false, "message" => "$field is required"]);
        exit();
    }
}

// Assign variables
$com_id         = $input["com_id"];
$item_id        = $input["item_id"];
$offer_title    = $input["offer_title"];
$offer_desc     = $input["offer_description"] ?? ""; // Optional
$start_time     = $input["start_time"];
$end_time       = $input["end_time"];
$discount_price = $input["discount_price"];
$reg_price      = $input["reg_price"];
$status         = $input["status"];
$create_by      = $input["create_by"];

// ===============================
// 3. Duplicate Check
// ===============================
// চেক করবে একই item এর জন্য একই title এর active offer আছে কিনা
$check_stmt = $con->prepare("
    SELECT offer_id 
    FROM item_special_offers 
    WHERE com_id = ? AND item_id = ? AND status=1
");
$check_stmt->bind_param("ss", $com_id, $item_id);
$check_stmt->execute();
$check_result = $check_stmt->get_result();

if ($check_result->num_rows > 0) {
    echo json_encode(["success" => "duplicate", "message" => "Offer already exists"]);
    $check_stmt->close();
    $con->close();
    exit();
}
$check_stmt->close();

// ===============================
// 4. Insert New Offer
// ===============================
$insert_stmt = $con->prepare("
    INSERT INTO item_special_offers 
    (com_id, item_id, offer_title, offer_description, start_time, end_time, discount_price, reg_price, status, create_by)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");

$insert_stmt->bind_param(
    "ssssssddis",
    $com_id,
    $item_id,
    $offer_title,
    $offer_desc,
    $start_time,
    $end_time,
    $discount_price,
    $reg_price,
    $status,
    $create_by
);

if ($insert_stmt->execute()) {
    echo json_encode(["success" => "true", "message" => "Offer inserted successfully"]);
} else {
    http_response_code(500);
    echo json_encode(["success" => "false", "error" => $insert_stmt->error]);
}

$insert_stmt->close();
$con->close();
?>
