<?php
include("../dbconn.php");
$con = dbconn();
mysqli_set_charset($con, "utf8mb4");

header('Content-Type: application/json; charset=utf-8');

// JSON POST body নেওয়া
$input = json_decode(file_get_contents("php://input"), true);

if (!$input) {
    http_response_code(400);
    echo json_encode(["success" => false, "error" => "Invalid JSON"]);
    exit;
}

// Required fields validation
$fields = ["offer_id", "com_id", "item_id", "offer_title", "start_time", "end_time", "discount_price", "reg_price", "status", "update_by"];
foreach ($fields as $field) {
    if (!isset($input[$field]) || $input[$field] === "") {
        echo json_encode(["success" => "false", "error" => "$field is required"]);
        exit;
    }
}
$offer_id        = $input['offer_id'];
$com_id          = $input['com_id'];
$item_id         = $input['item_id'];
$offer_title     = $input['offer_title'];
$offer_desc      = $input['offer_description'] ?? null;
$start_time      = $input['start_time'];
$end_time        = $input['end_time'];
$discount_price  = $input['discount_price'];
$reg_price       = $input['reg_price'];
$status          = $input['status'];
$update_by       = $input['update_by'];

// Update query
$update_sql = "UPDATE item_special_offers SET 
                        offer_title = ?, 
                        offer_description = ?, 
                        start_time = ?, 
                        end_time = ?, 
                        discount_price = ?, 
                        reg_price = ?, 
                        status = ?, 
                        update_by = ?, 
                        update_date = NOW()
                    WHERE offer_id = ?";
$update_stmt = $con->prepare($update_sql);
$update_stmt->bind_param(
        "ssssddisi",
        $offer_title,
        $offer_desc,
        $start_time,
        $end_time,
        $discount_price,
        $reg_price,
        $status,
        $update_by,
        $offer_id
    );

if ($update_stmt->execute()) {
    echo json_encode(["success" => "true"]);
} else {
    echo json_encode(["success" => "false", "error" => $update_stmt->error]);
}

$update_stmt->close();
$con->close();
?>
