<?php
include("../dbconn.php");
$con = dbconn();
mysqli_set_charset($con, "utf8mb4");

header('Content-Type: application/json; charset=utf-8');

$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

$action = $input['action'] ?? "";

switch ($action) {
// =================== INSERT ORDER + ITEMS ===================
case 'insert':
        $con->begin_transaction();
        try {
            $order_id = $input['order_id'] ?? "";
            $com_id = $input['com_id'] ?? "";
            $customer_name = $input['customer_name'] ?? "";
            $mobile_no = $input['mobile_no'] ?? "";
            $country = $input['country'] ?? "Bangladesh";
            $address = $input['address'] ?? "";
            $district = $input['district'] ?? "Dhaka";
            $order_note = $input['order_note'] ?? null;
            $service_charge = floatval($input['service_charge'] ?? 0);
            $total_bill = floatval($input['total_bill'] ?? 0);
            $payment_method = $input['payment_method'] ?? "Cash on Delivery";
            $order_medium = $input['order_medium'] ?? "Facebook Boost";
            $status = $input['status'] ?? "New";
            $create_by = $input['create_by'] ?? "Customer";

            // ✅ FIXED bind_param type
            $stmt = $con->prepare("INSERT INTO orders_info 
                (order_id,com_id, customer_name, mobile_no, country, address, district, order_note, service_charge, total_bill, payment_method, order_medium, status, create_by)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param(
                "ssssssssddssss",
                $order_id,
                $com_id,
                $customer_name,
                $mobile_no,
                $country,
                $address,
                $district,
                $order_note,
                $service_charge,
                $total_bill,
                $payment_method,
                $order_medium,
                $status,
                $create_by
            );
            $stmt->execute();

          //  $order_id = $con->insert_id;

            // ✅ Insert order items
            $items = $input['items'] ?? [];
            foreach ($items as $item) {
                $order_id = $item['order_id'] ?? "";
                $com_id = $item['com_id'] ?? "";
                $item_id = $item['item_id'] ?? "";
                $item_color = intval($item['item_color'] ?? 0);
                $item_size = intval($item['item_size'] ?? 0);
                $quantity = intval($item['quantity'] ?? 0);
                $discount_price = floatval($item['discount_price'] ?? 0);
                $reg_price = floatval($item['reg_price'] ?? 0);
                $item_total = floatval($item['item_total'] ?? 0);
                $trading_price = floatval($item['trading_price'] ?? 0);
                $create_by = $item['create_by'] ?? "Customer";

                $stmtItem = $con->prepare("INSERT INTO items_order 
                    (order_id, com_id, item_id, item_color, item_size, quantity, discount_price, reg_price, item_total, trading_price, create_date, create_by)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?)");
                $stmtItem->bind_param(
                    "sssiiidddds",
                    $order_id,
                    $com_id,
                    $item_id,
                    $item_color,
                    $item_size,
                    $quantity,
                    $discount_price,
                    $reg_price,
                    $item_total,
                    $trading_price,
                    $create_by
                );
                $stmtItem->execute();
            }

            $con->commit();
            echo json_encode(["success" => "true", "order_id" => $order_id]);
        } catch (Exception $e) {
            $con->rollback();
            echo json_encode(["success" => "false", "error" => $e->getMessage()]);
        }
        break;

    // =================== UPDATE ORDER + ITEMS ===================
    case 'update':
        $con->begin_transaction();
        try {
            $order_id =  $input['order_id'] ?? "";
            $com_id = $input['com_id'] ?? "";
            $customer_name = $input['customer_name'] ?? "";
            $mobile_no = $input['mobile_no'] ?? "";
            $country = $input['country'] ?? "Bangladesh";
            $address = $input['address'] ?? "";
            $district = $input['district'] ?? "Dhaka";
            $order_note = $input['order_note'] ?? null;
            $service_charge = floatval($input['service_charge'] ?? 0);
            $total_bill = floatval($input['total_bill'] ?? 0);
            $payment_method = $input['payment_method'] ?? "Cash on Delivery";
            $order_medium = $input['order_medium'] ?? "Facebook Boost";
            $status = $input['status'] ?? "New";
            $update_by = $input['update_by'] ?? "Admin";

            $stmt = $con->prepare("UPDATE orders_info SET 
                com_id=?, customer_name=?, mobile_no=?, country=?, address=?, district=?, order_note=?, 
                service_charge=?, total_bill=?, payment_method=?, order_medium=?, status=?, 
                update_by=?, update_date=NOW()
                WHERE order_id=?");

            // ✅ FIXED bind_param types
            $stmt->bind_param(
                "sssssssddsssss",
                $com_id,
                $customer_name,
                $mobile_no,
                $country,
                $address,
                $district,
                $order_note,
                $service_charge,
                $total_bill,
                $payment_method,
                $order_medium,
                $status,
                $update_by,
                $order_id
            );
            $stmt->execute();

            // Delete old items before inserting new ones
            $stmtDel = $con->prepare("DELETE FROM items_order WHERE order_id=?");
            $stmtDel->bind_param("s", $order_id);
            $stmtDel->execute();

            // Insert updated items
            $items = $input['items'] ?? [];
            foreach ($items as $item) {
                $order_id = $item['order_id'] ?? "";
                $com_id = $item['com_id'] ?? "";
                $item_id = $item['item_id'] ?? "";
                $item_color = intval($item['item_color'] ?? 0);
                $item_size = intval($item['item_size'] ?? 0);
                $quantity = intval($item['quantity'] ?? 0);
                $discount_price = floatval($item['discount_price'] ?? 0);
                $reg_price = floatval($item['reg_price'] ?? 0);
                $item_total = floatval($item['item_total'] ?? 0);
                $trading_price = floatval($item['trading_price'] ?? 0);
                $update_by = $item['update_by'] ?? "Admin";

                $stmtItem = $con->prepare("INSERT INTO items_order 
                    (order_id, com_id, item_id, item_color, item_size, quantity, discount_price, reg_price, item_total, trading_price, create_date, create_by)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?)");
                $stmtItem->bind_param(
                    "sssiiiiddds",
                    $order_id,
                    $com_id,
                    $item_id,
                    $item_color,
                    $item_size,
                    $quantity,
                    $discount_price,
                    $reg_price,
                    $item_total,
                    $trading_price,
                    $update_by
                );
                $stmtItem->execute();
            }

            $con->commit();
            echo json_encode(["success" => "true"]);
        } catch (Exception $e) {
            $con->rollback();
            echo json_encode(["success" => "false", "error" => $e->getMessage()]);
        }
        break;


    // =================== DELETE ===================
    case 'delete':
        $order_id = $item['order_id'] ?? "";
        $con->begin_transaction();
        try {
            $stmt1 = $con->prepare("DELETE FROM items_order WHERE order_id=?");
            $stmt1->bind_param("s", $order_id);
            $stmt1->execute();

            $stmt2 = $con->prepare("DELETE FROM orders_info WHERE order_id=?");
            $stmt2->bind_param("s", $order_id);
            $stmt2->execute();

            $con->commit();
            echo json_encode(["success" => "true"]);
        } catch (Exception $e) {
            $con->rollback();
            echo json_encode(["success" => "false", "error" => $e->getMessage()]);
        }
        break;

   // =================== FETCH ALL ===================
case 'fetchAll':
    $com_id = $input['com_id'] ?? "";
    $orders = [];

    // Fetch all orders first
    $stmt = $con->prepare("
        SELECT 
            order_id,
            com_id,
            customer_name,
            mobile_no,
            country,
            address,
            district,
            order_note,
            service_charge,
            total_bill,
            payment_method,
            order_medium,
            status,
            create_by,
            create_date
        FROM orders_info
        WHERE com_id = ?
        ORDER BY create_date ASC
    ");
    $stmt->bind_param("s", $com_id);
    $stmt->execute();
    $orders_res = $stmt->get_result();

    while ($order = $orders_res->fetch_assoc()) {

        // ✅ Fetch items for this order
        $stmt_items = $con->prepare("
            SELECT 
                b.com_id,
                b.order_id,
                b.item_id,
                b.item_color,
                b.item_size,
                b.quantity,
                b.discount_price,
                b.reg_price,
                b.item_total,
                b.trading_price,
                b.create_by,
                d.item_name,
                c.color_name,
                c.image_name
            FROM items_order b
            INNER JOIN item_color c ON b.item_color = c.item_color_id
            INNER JOIN item_details d ON b.item_id = d.item_id
            WHERE b.order_id = ? AND b.com_id = ?
        ");
        $stmt_items->bind_param("ss", $order['order_id'], $com_id);
        $stmt_items->execute();
        $res_items = $stmt_items->get_result();

        $items = [];
        while ($row_item = $res_items->fetch_assoc()) {
            $items[] = $row_item;
        }

        // ✅ Attach items to order
        $order['items'] = $items;

        // ✅ Push to orders array
        $orders[] = $order;
    }

    // ✅ Important: return JSON with correct headers
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($orders, JSON_UNESCAPED_UNICODE);
    break;


    // =================== FETCH BY ORDER ID ===================
case 'fetchByOrderId':
    $order_id = $input['order_id'] ?? "";
    $com_id = $input['com_id'] ?? "";

    $stmt = $con->prepare("
SELECT 
            a.order_id,
            a.customer_name,
            a.mobile_no,
            a.address,
            a.district,
            a.service_charge,
            a.total_bill,
            a.payment_method,
            a.order_medium,
            a.status,
            a.create_date,
            d.item_name,
            b.quantity,
            b.discount_price,
            b.item_total,
            c.color_name
        FROM orders_info a
        INNER JOIN items_order b ON a.order_id = b.order_id AND a.com_id = b.com_id
        INNER JOIN item_color c ON b.item_color = c.item_color_id
        INNER JOIN item_details d ON b.item_id = d.item_id
        WHERE a.com_id = ? AND a.order_id = ?
    ");
    $stmt->bind_param("ss", $com_id, $order_id);
    $stmt->execute();
    $res = $stmt->get_result();

    if ($res->num_rows === 0) {
        echo json_encode(["success" => "false", "message" => "Order not found"]);
        exit;
    }

    $data = [];
    while ($row = $res->fetch_assoc()) {
        $data[] = $row;
    }
    echo json_encode($data);
    break;


    // =================== FETCH BY STATUS ===================
case 'fetchByStatus':
    $status = $input['status'] ?? "New";
    $com_id = $input['com_id'] ?? "";

    $stmt = $con->prepare("
SELECT 
            a.order_id,
            a.customer_name,
            a.mobile_no,
            a.address,
            a.district,
            a.service_charge,
            a.total_bill,
            a.payment_method,
            a.order_medium,
            a.status,
            a.create_date,
            d.item_name,
            b.quantity,
            b.discount_price,
            b.item_total,
            c.color_name
        FROM orders_info a
        INNER JOIN items_order b ON a.order_id = b.order_id AND a.com_id = b.com_id
        INNER JOIN item_color c ON b.item_color = c.item_color_id
        INNER JOIN item_details d ON b.item_id = d.item_id
        WHERE a.com_id = ? AND a.status = ?
        ORDER BY a.create_date DESC
    ");
    $stmt->bind_param("ss", $com_id, $status);
    $stmt->execute();
    $res = $stmt->get_result();

    $data = [];
    while ($row = $res->fetch_assoc()) {
        $data[] = $row;
    }
    echo json_encode($data);
    break;
    default:
        echo json_encode(["error" => "Invalid action"]);
}
?>
