<?php
include("../dbconn.php");
$con = dbconn();
mysqli_set_charset($con, "utf8mb4");

header('Content-Type: application/json; charset=utf-8');

$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

$action = $input['action'] ?? "";
$com_id = $input['com_id'] ?? "";

switch ($action) {
// =================== INSERT ORDER + ITEMS ===================
case 'insert':
    $con->begin_transaction();
    try {
        // Generate new order_id
        $prefix = "ORD";
        $stmt = $con->prepare("SELECT MAX(order_id) AS last_id FROM orders_info WHERE com_id = ?");
$stmt->bind_param("s", $com_id);
$stmt->execute();
$result = $stmt->get_result();
        $row = $result->fetch_assoc();

        if ($row && $row['last_id']) {
            // Extract numeric part (e.g. 100001 from ORD100001)
            $lastNum = intval(substr($row['last_id'], 3));
            $newNum = $lastNum + 1;
        } else {
            $newNum = 100001; // first order
        }

        $order_id = $prefix . str_pad($newNum, 6, '0', STR_PAD_LEFT);

        // Read other inputs
        $com_id = $input['com_id'] ?? "";
        $customer_name = $input['customer_name'] ?? "";
        $mobile_no = $input['mobile_no'] ?? "";
        $country = $input['country'] ?? "Bangladesh";
        $address = $input['address'] ?? "";
        $district = $input['district'] ?? "Dhaka";
        $order_note = $input['order_note'] ?? null;
        $service_charge = floatval($input['service_charge'] ?? 0);
        $total_bill = floatval($input['total_bill'] ?? 0);
        $payment_method = $input['payment_method'] ?? "Cash on Delivery";
        $order_medium = $input['order_medium'] ?? "Facebook Boost";
        $status = $input['status'] ?? "New";
        $create_by = $input['create_by'] ?? "Customer";

        // ✅ Insert into orders_info
        $stmt = $con->prepare("INSERT INTO orders_info 
            (order_id, com_id, customer_name, mobile_no, country, address, district, order_note, service_charge, total_bill, payment_method, order_medium, status, create_by)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param(
            "ssssssssddssss",
            $order_id,
            $com_id,
            $customer_name,
            $mobile_no,
            $country,
            $address,
            $district,
            $order_note,
            $service_charge,
            $total_bill,
            $payment_method,
            $order_medium,
            $status,
            $create_by
        );
        $stmt->execute();
          
          // Insert into Orders_log
          $stmtOrderLog = $con->prepare("INSERT INTO orders_log 
            (com_id, order_id, status,remarks, create_by)
            VALUES (?, ?, ?, ?, ?)");
        $stmtOrderLog->bind_param(
            "sssss",
            $com_id,
            $order_id,
            $status,
            $order_note,
            $create_by
        );
        $stmtOrderLog->execute();
        

        // ✅ Insert order items
        $items = $input['items'] ?? [];
        foreach ($items as $item) {
            $item_id = $item['item_id'] ?? "";
            $item_color = intval($item['item_color'] ?? 0);
            $item_size = intval($item['item_size'] ?? 0);
            $quantity = intval($item['quantity'] ?? 0);
            $discount_price = floatval($item['discount_price'] ?? 0);
            $reg_price = floatval($item['reg_price'] ?? 0);
            $item_total = floatval($item['item_total'] ?? 0);
            $trading_price = floatval($item['trading_price'] ?? 0);
            $create_by = $item['create_by'] ?? "Customer";

            $stmtItem = $con->prepare("INSERT INTO items_order 
                (order_id, com_id, item_id, item_color, item_size, quantity, discount_price, reg_price, item_total, trading_price, create_date, create_by)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?)");
            $stmtItem->bind_param(
                "sssiiidddds",
                $order_id,
                $com_id,
                $item_id,
                $item_color,
                $item_size,
                $quantity,
                $discount_price,
                $reg_price,
                $item_total,
                $trading_price,
                $create_by
            );
            $stmtItem->execute();
        }

        $con->commit();
        echo json_encode(["success" => "true", "order_id" => $order_id]);

    } catch (Exception $e) {
        $con->rollback();
        echo json_encode(["success" => "false", "error" => $e->getMessage()]);
    }
    break;


    // =================== UPDATE ORDER + ITEMS ===================
    case 'update':
        $con->begin_transaction();
        try {
            $order_id =  $input['order_id'] ?? "";
            $com_id = $input['com_id'] ?? "";
            $customer_name = $input['customer_name'] ?? "";
            $mobile_no = $input['mobile_no'] ?? "";
            $country = $input['country'] ?? "Bangladesh";
            $address = $input['address'] ?? "";
            $district = $input['district'] ?? "Dhaka";
            $order_note = $input['order_note'] ?? null;
            $service_charge = floatval($input['service_charge'] ?? 0);
            $total_bill = floatval($input['total_bill'] ?? 0);
            $payment_method = $input['payment_method'] ?? "Cash on Delivery";
            $order_medium = $input['order_medium'] ?? "Facebook Boost";
            $status = $input['status'] ?? "New";
            $update_by = $input['update_by'] ?? "Admin";


            $stmt = $con->prepare("UPDATE orders_info SET 
                com_id=?, customer_name=?, mobile_no=?, country=?, address=?, district=?, order_note=?, 
                service_charge=?, total_bill=?, payment_method=?, order_medium=?, status=?, 
                update_by=?, update_date=NOW()
                WHERE order_id=?");
            // ✅ FIXED bind_param types
            $stmt->bind_param(
                "sssssssddsssss",
                $com_id,
                $customer_name,
                $mobile_no,
                $country,
                $address,
                $district,
                $order_note,
                $service_charge,
                $total_bill,
                $payment_method,
                $order_medium,
                $status,
                $update_by,
                $order_id
            );
            $stmt->execute();
            
            

            // Delete old items before inserting new ones
            $stmtDel = $con->prepare("DELETE FROM items_order WHERE order_id=?");
            $stmtDel->bind_param("s", $order_id);
            $stmtDel->execute();

            // Insert updated items
            $items = $input['items'] ?? [];
            foreach ($items as $item) {
                $order_id = $item['order_id'] ?? "";
                $com_id = $item['com_id'] ?? "";
                $item_id = $item['item_id'] ?? "";
                $item_color = intval($item['item_color'] ?? 0);
                $item_size = intval($item['item_size'] ?? 0);
                $quantity = intval($item['quantity'] ?? 0);
                $discount_price = floatval($item['discount_price'] ?? 0);
                $reg_price = floatval($item['reg_price'] ?? 0);
                $item_total = floatval($item['item_total'] ?? 0);
                $trading_price = floatval($item['trading_price'] ?? 0);
                $update_by = $item['update_by'] ?? "Admin";

                $stmtItem = $con->prepare("INSERT INTO items_order 
                    (order_id, com_id, item_id, item_color, item_size, quantity, discount_price, reg_price, item_total, trading_price, create_date, create_by)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?)");
                $stmtItem->bind_param(
                    "sssiiiiddds",
                    $order_id,
                    $com_id,
                    $item_id,
                    $item_color,
                    $item_size,
                    $quantity,
                    $discount_price,
                    $reg_price,
                    $item_total,
                    $trading_price,
                    $update_by
                );
                $stmtItem->execute();
            }

            $con->commit();
            echo json_encode(["success" => "true"]);
        } catch (Exception $e) {
            $con->rollback();
            echo json_encode(["success" => "false", "error" => $e->getMessage()]);
        }
        break;

// =================== UPDATE ORDER STATUS ===================
case 'updateStatus':

    $con->begin_transaction();

    try {

        $order_id  = trim($input['order_id'] ?? "");
        $com_id    = trim($input['com_id'] ?? "");
        $status    = trim($input['status'] ?? "New");
        $update_by = trim($input['update_by'] ?? "Admin");
        $remarks   = $input['remarks'] ?? "null";
        $patron_id = $input['patron_id'] ?? "";

        if (empty($order_id) || empty($com_id)) {
            throw new Exception("Missing order_id or com_id");
        }

        // ----------------------------------------------------
        // 1) UPDATE orders_info
        // ----------------------------------------------------
        $stmt = $con->prepare("
            UPDATE orders_info 
            SET status = ?, update_by = ?, update_date = NOW() 
            WHERE com_id = ? AND order_id = ?
        ");
        $stmt->bind_param("ssss", $status, $update_by, $com_id, $order_id);
        $stmt->execute();


        // ----------------------------------------------------
        // 2) Insert into orders_log
        // ----------------------------------------------------
        $stmtLog = $con->prepare("
            INSERT INTO orders_log 
            (com_id, order_id, status, remarks, patron_id, create_by)
            VALUES (?, ?, ?, ?, ?, ?)
        ");
        $stmtLog->bind_param("ssssss", $com_id, $order_id, $status, $remarks, $patron_id, $update_by);
        $stmtLog->execute();


        // ----------------------------------------------------
        // 3) If status = Shipped → Insert items into inventory
        // ----------------------------------------------------
        if ($status == "Shipped") {

            // 3.1 — Fetch order items
            $stmtItems = $con->prepare("
                SELECT item_id, quantity, discount_price 
                FROM items_order
                WHERE com_id = ? AND order_id = ?
            ");
            $stmtItems->bind_param("ss", $com_id, $order_id);
            $stmtItems->execute();
            $result = $stmtItems->get_result();

            if ($result->num_rows > 0) {

                // Prepare insert query
                $stmtInv = $con->prepare("
                    INSERT INTO inventory
                    (com_id, tr_period, tr_acc_id, tr_menu_flag, tr_date,
                     tr_ref_bill_no, tr_gl_ref_no, tr_mode, patron_id, item_id,
                     tr_quantity, tr_unit_price, tr_total, tr_vat, create_by)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
                ");

                $tr_period = date("Ym");      // e.g., 202511
                $tr_date   = date("Y-m-d");
                $tr_acc_id = "41010101";      // Sales account
                $tr_menu_flag = "SA";         // Sales
                $tr_mode = "3";               // Mode flag
                $tr_gl_ref_no = $order_id;
                $tr_vat = 0;
                

                while ($row = $result->fetch_assoc()) {

                    $item_id = $row['item_id'];
                    $qty     = $row['quantity'];
                    $price   = $row['discount_price'];
                    $total   = $qty * $price;

                    $tr_ref_bill_no = "SA/". $order_id;

                    // Correct bind types for 15 params
                    $stmtInv->bind_param(
                        "ssssssssssiddds",
                        $com_id,
                        $tr_period,
                        $tr_acc_id,
                        $tr_menu_flag,
                        $tr_date,
                        $tr_ref_bill_no,
                        $tr_gl_ref_no,
                        $tr_mode,
                        $patron_id,
                        $item_id,
                        $qty,
                        $price,
                        $total,
                        $tr_vat,
                        $update_by
                    );

                    // Execute insert
                    if (!$stmtInv->execute()) {
                        throw new Exception("Inventory Insert Failed: " . $stmtInv->error);
                    }
                }
            }
            
            // Insert and update into GL
        $tr_gl_menu_flag = "I";  
        // Debit / Credit Accounts
        
        $tr_pay_acc_id  = "11010401";          // Paying account (Nothing now)
        $tr_rec_acc_id  = "41010101";           // Courier Payable account
        $tr_rec_personel_id="";
        // Amounts
$sql = "SELECT SUM(item_total) AS total_amount 
        FROM items_order 
        WHERE com_id=? AND order_id=?";

$stmt = $con->prepare($sql);
$stmt->bind_param("ss", $com_id, $order_id);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
$tr_pay_am = floatval($row['total_amount']);

        // Status Flags
        $tr_pay_status   = "DR";
        $tr_rec_status   = "CR";
        $tr_cash_am      = 0;
        $tr_cash_status  = "";

        $tr_bank_id      = "";
        $tr_bank_reff_no = "";
        $tr_bank_am      = 0;
        $tr_bank_status  = "";
        $tr_narration = "On credit to " . $patron_id . " against A/c " . $tr_rec_acc_id;

        $stmtLedger = $con->prepare("
            INSERT INTO general_ledger(
                com_id, tr_period, tr_date, tr_mode, tr_gL_ref_no,
                tr_pay_acc_id, tr_pay_personel_id, tr_pay_am, tr_pay_status,tr_cash_am, tr_cash_status, tr_bank_id, tr_bank_reff_no,
                tr_bank_am, tr_bank_status,
                tr_rec_acc_id, tr_rec_personel_id,
                tr_rec_am, tr_rec_status, tr_narration, tr_menu_flag, create_by
            )
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?)
        ");

        $stmtLedger->bind_param(
            "sssisssdsdsssdsssdssss",
            $com_id,
            $tr_period,
            $tr_date,
            $tr_mode,
            $tr_gl_ref_no,
            $tr_pay_acc_id,
            $patron_id,
            $tr_pay_am,
            $tr_pay_status,
            $tr_cash_am,
            $tr_cash_status,
            $tr_bank_id,
            $tr_bank_reff_no,
            $tr_bank_am,
            $tr_bank_status,
            $tr_rec_acc_id,
            $tr_rec_personel_id,
            $tr_pay_am,
            $tr_rec_status,
            $tr_narration,
            $tr_gl_menu_flag,
            $update_by
        );

        if (!$stmtLedger->execute()) {
            throw new Exception("Ledger Insert Failed: " . $stmtLedger->error);
        }
        }
        
        
        
        
        
        
        
        
        
        
        


        // ----------------------------------------------------
        // 4) Commit success
        // ----------------------------------------------------
        $con->commit();
        echo json_encode(["success" => "true", "message" => "Status updated successfully"]);
    }

    catch (Exception $e) {
        $con->rollback();
        echo json_encode(["success" => "false", "error" => $e->getMessage()]);
    }

    break;


    
    // =================== DELETE ===================
    case 'delete':
        $order_id = $item['order_id'] ?? "";
        $con->begin_transaction();
        try {
            $stmt1 = $con->prepare("DELETE FROM items_order WHERE order_id=?");
            $stmt1->bind_param("s", $order_id);
            $stmt1->execute();

            $stmt2 = $con->prepare("DELETE FROM orders_info WHERE order_id=?");
            $stmt2->bind_param("s", $order_id);
            $stmt2->execute();

            $con->commit();
            echo json_encode(["success" => "true"]);
        } catch (Exception $e) {
            $con->rollback();
            echo json_encode(["success" => "false", "error" => $e->getMessage()]);
        }
        break;
        
 // ========== DELETE ITEM Only and Update Orders_Info Table==================
   case 'deleteOrderItem':

    // 1. Decode JSON input
    $input = json_decode(file_get_contents("php://input"), true);
    $item = $input;

    $order_id = $item['order_id'] ?? "";
    $com_id   = $item['com_id'] ?? "";
    $items    = $item['items'] ?? [];  // items array

    // 2. Validate
    if (empty($order_id) || empty($com_id) || empty($items)) {
        echo json_encode(["success" => "false", "error" => "Invalid input"]);
        break;
    }

    // 3. Get first item_id
    //$item_id = $items[0]['item_id'] ?? "";
    //$item_color = $items[0]['item_color'] ?? "";
    $order_item_id = $items[0]['order_item_id'] ?? 0;
    
    if (empty($order_item_id)) {
        echo json_encode(["success" => "false", "error" => "Missing item_id"]);
        break;
    }

    $con->begin_transaction();

    try {

        // Delete the item
        $stmtDelete = $con->prepare("
            DELETE FROM items_order 
            WHERE order_item_id=?
        ");
        $stmtDelete->bind_param("i", $order_item_id);
        $stmtDelete->execute();

        // Recalculate total_bill
        $stmtSum = $con->prepare("
            SELECT IFNULL(SUM(a.discount_price * a.quantity) + 
                   IFNULL(b.service_charge,0),0) 
            FROM items_order a, orders_info b
            WHERE a.com_id=? AND a.order_id=?
            AND a.com_id=b.com_id
            AND a.order_id=b.order_id
        ");
        $stmtSum->bind_param("ss", $com_id, $order_id);
        $stmtSum->execute();
        $stmtSum->bind_result($new_total_bill);
        $stmtSum->fetch();
        $stmtSum->close();

        // Update orders_info
        $stmtUpdate = $con->prepare("
            UPDATE orders_info 
            SET total_bill=? 
            WHERE com_id=? AND order_id=?
        ");
        $stmtUpdate->bind_param("dss", $new_total_bill, $com_id, $order_id);
        $stmtUpdate->execute();

        $con->commit();

        echo json_encode([
            "success" => "true",
            "new_total_bill" => $new_total_bill
        ]);

    } catch (Exception $e) {
        $con->rollback();
        echo json_encode(["success" => "false", "error" => $e->getMessage()]);
    }

    break;






   // =================== FETCH ALL ===================
case 'fetchAll':
    $com_id = $input['com_id'] ?? "";
    $orders = [];

    // Fetch all orders first
    $stmt = $con->prepare("
        SELECT 
            order_id,
            com_id,
            customer_name,
            mobile_no,
            country,
            address,
            district,
            order_note,
            service_charge,
            total_bill,
            payment_method,
            order_medium,
            status,
            create_by,
            create_date
        FROM orders_info
        WHERE com_id = ?
        ORDER BY create_date ASC
    ");
    $stmt->bind_param("s", $com_id);
    $stmt->execute();
    $orders_res = $stmt->get_result();

    while ($order = $orders_res->fetch_assoc()) {

        // ✅ Fetch items for this order
        $stmt_items = $con->prepare("
            SELECT
                b.order_item_id,
                b.com_id,
                b.order_id,
                b.item_id,
                b.item_color,
                b.item_size,
                b.quantity,
                b.discount_price,
                b.reg_price,
                b.item_total,
                b.trading_price,
                b.create_by,
                d.item_name,
                c.color_name,
                c.image_name
            FROM items_order b
            INNER JOIN item_color c ON b.item_color = c.item_color_id
            INNER JOIN item_details d ON b.item_id = d.item_id
            WHERE b.order_id = ? AND b.com_id = ?
        ");
        $stmt_items->bind_param("ss", $order['order_id'], $com_id);
        $stmt_items->execute();
        $res_items = $stmt_items->get_result();

        $items = [];
        while ($row_item = $res_items->fetch_assoc()) {
            $items[] = $row_item;
        }

        // ✅ Attach items to order
        $order['items'] = $items;

        // ✅ Push to orders array
        $orders[] = $order;
    }

    // ✅ Important: return JSON with correct headers
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($orders, JSON_UNESCAPED_UNICODE);
    break;


    // =================== FETCH BY ORDER ID ===================
case 'fetchByOrderId':
    $order_id = $input['order_id'] ?? "";
    $com_id = $input['com_id'] ?? "";

    $stmt = $con->prepare("
SELECT 
            a.order_id,
            a.customer_name,
            a.mobile_no,
            a.address,
            a.district,
            a.service_charge,
            a.total_bill,
            a.payment_method,
            a.order_medium,
            a.status,
            a.create_date,
            b.order_item_id,
            d.item_name,
            b.quantity,
            b.discount_price,
            b.item_total,
            c.color_name
        FROM orders_info a
        INNER JOIN items_order b ON a.order_id = b.order_id AND a.com_id = b.com_id
        INNER JOIN item_color c ON b.item_color = c.item_color_id
        INNER JOIN item_details d ON b.item_id = d.item_id
        WHERE a.com_id = ? AND a.order_id = ?
    ");
    $stmt->bind_param("ss", $com_id, $order_id);
    $stmt->execute();
    $res = $stmt->get_result();

    if ($res->num_rows === 0) {
        echo json_encode(["success" => "false", "message" => "Order not found"]);
        exit;
    }

    $data = [];
    while ($row = $res->fetch_assoc()) {
        $data[] = $row;
    }
    echo json_encode($data);
    break;


    // =================== FETCH BY STATUS ===================
case 'fetchByStatus':
    $status = $input['status'] ?? "New";
    $com_id = $input['com_id'] ?? "";

    $stmt = $con->prepare("
SELECT 
            a.order_id,
            a.customer_name,
            a.mobile_no,
            a.address,
            a.district,
            a.service_charge,
            a.total_bill,
            a.payment_method,
            a.order_medium,
            a.status,
            a.create_date,
            d.item_name,
            b.quantity,
            b.discount_price,
            b.item_total,
            c.color_name
        FROM orders_info a
        INNER JOIN items_order b ON a.order_id = b.order_id AND a.com_id = b.com_id
        INNER JOIN item_color c ON b.item_color = c.item_color_id
        INNER JOIN item_details d ON b.item_id = d.item_id
        WHERE a.com_id = ? AND a.status = ?
        ORDER BY a.create_date DESC
    ");
    $stmt->bind_param("ss", $com_id, $status);
    $stmt->execute();
    $res = $stmt->get_result();

    $data = [];
    while ($row = $res->fetch_assoc()) {
        $data[] = $row;
    }
    echo json_encode($data);
    break;
    // =================== FETCH BY OODER LOG BY ORDER ID ===================
case 'fetchOrderLogByOrderId':

    $order_id = $input['order_id'] ?? "";
    $com_id   = $input['com_id'] ?? "";

    $stmt = $con->prepare("
        SELECT  
            a.order_id,
            a.status,
            a.remarks,
            COALESCE(c.patron_name, '') AS patron_name,
            a.create_date,
            COALESCE(b.user_name, 'Customer') AS create_by
        FROM orders_log a
        LEFT JOIN user_info b 
            ON a.create_by = b.user_id LEFT JOIN patron_info c ON a.patron_id=c.patron_id
        WHERE a.com_id = ?
          AND a.order_id = ?
        ORDER BY a.id ASC
    ");

    $stmt->bind_param("ss", $com_id, $order_id);
    $stmt->execute();
    $res = $stmt->get_result();

    if ($res->num_rows === 0) {
        echo json_encode([
            "success" => false,
            "message" => "No logs found"
        ]);
        exit;
    }

    $data = [];
    while ($row = $res->fetch_assoc()) {
        $data[] = $row;
    }

    echo json_encode($data);
    break;

    
    default:
        echo json_encode(["error" => "Invalid action"]);
}
?>
