<?php
include("../dbconn.php");
$con = dbconn();

header('Content-Type: application/json');

if (!isset($_POST["user_email"]) || !isset($_POST["image_name"])) {
    echo json_encode(["success" => "false"]);
    exit;
}

$user_email = $_POST["user_email"];
$image_name = $_POST["image_name"];
$path = "../image/$image_name";

// Delete image file if it exists
if (file_exists($path)) {
    unlink($path);
}

// Use prepared statement to avoid SQL injection
$stmt = $con->prepare("DELETE FROM user_info WHERE user_email = ?");
$stmt->bind_param("s", $user_email);

$response = [];

if ($stmt->execute()) {
    $response["success"] = "true";
} else {
    $response["success"] = "false";
}

echo json_encode($response);
?>
