<?php
include("../dbconn.php");
$con = dbconn();

header('Content-Type: application/json');

if (!isset($_POST["user_email"])) {
    echo json_encode([["success" => "false"]]);
    exit;
}

$user_email = $_POST["user_email"];

$stmt = $con->prepare("SELECT user_id, user_name, user_email, contact_no, image_name, create_date, update_date FROM user_info WHERE user_email = ?");
$stmt->bind_param("s", $user_email);
$stmt->execute();
$result = $stmt->get_result();

$response = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $row["success"] = "true";
        $response[] = $row;
    }
    echo json_encode($response);
} else {
    echo json_encode(["success" => "false"]);
}
?>
