<?php
include("../dbconn.php");
$con = dbconn();

header('Content-Type: application/json');

if (isset($_POST["user_email"]) && isset($_POST["user_password"])) {
    $user_email = $_POST["user_email"];
    $user_password = $_POST["user_password"];

    $stmt = $con->prepare("SELECT * FROM user_info WHERE user_email = ?");
    $stmt->bind_param("s", $user_email);
    $stmt->execute();
    $result = $stmt->get_result();

    $arr = [];

    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();

        if (password_verify($user_password, $row['user_password'])) {
            unset($row['user_password']);
            $row["success"] = "true";
            $arr[] = $row;
        } else {
            $arr[] = ["success" => "false"];
        }
    } else {
        $arr[] = ["success" => "false"];
    }

    echo json_encode($arr);
} else {
    echo json_encode([
        ["success" => "false"]
    ]);
}
?>
