<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

// Database connect
include("../dbconn.php");
$con = dbconn();

// Collect and validate required fields
$requiredFields = ["com_id", "user_id", "user_name", "user_email", "contact_no", "user_password", "image_name", "imageData"];
foreach ($requiredFields as $field) {
    if (!isset($_POST[$field])) {
        echo json_encode(["success" => "false", "error" => "$field is missing"]);
        exit();
    }
}

// Sanitize and assign
$com_id       = $_POST["com_id"];
$user_id      = $_POST["user_id"];
$user_name    = $_POST["user_name"];
$user_email   = $_POST["user_email"];
$contact_no   = $_POST["contact_no"];
$user_password = password_hash($_POST["user_password"], PASSWORD_DEFAULT);
$image_name   = basename($_POST["image_name"]); // strip any path tricks
$imageData    = $_POST["imageData"];

// Save image
$imagePath = "../image/profile_image/" . $image_name;
if (!file_put_contents($imagePath, base64_decode($imageData))) {
    echo json_encode(["success" => "false", "error" => "Image save failed"]);
    exit();
}

// Insert with Prepared Statement
$stmt = $con->prepare("INSERT INTO user_info (com_id, user_id, user_name, user_email, contact_no, user_password, image_name) VALUES (?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("sssssss", $com_id, $user_id, $user_name, $user_email, $contact_no, $user_password, $image_name);

if ($stmt->execute()) {
    echo json_encode(["success" => "true"]);
} else {
    echo json_encode(["success" => "false", "error" => $stmt->error]);
}

$stmt->close();
$con->close();
?>
