<?php
include("../dbconn.php");
$con = dbconn();

header('Content-Type: application/json');

$required_fields = ["user_email", "user_password"];
foreach ($required_fields as $field) {
    if (!isset($_POST[$field])) {
        echo json_encode(["success" => "false", "error" => "$field is missing"]);
        exit;
    }
}

$user_email = $_POST["user_email"];
$user_password_raw = $_POST["user_password"];
$user_password = password_hash($user_password_raw, PASSWORD_DEFAULT); // Hash the password

// Prepared statement to prevent SQL injection
$stmt = $con->prepare("UPDATE user_info SET user_password = ? WHERE user_email = ?");
$stmt->bind_param("ss", $user_password, $user_email);

$response = [];

if ($stmt->execute()) {
    $response["success"] = "true";
} else {
    $response["success"] = "false";
    $response["error"] = "Password update failed.";
}

echo json_encode($response);
?>
