<?php
include("../dbconn.php");
$con = dbconn();

header('Content-Type: application/json');

$required_fields = ["user_id", "user_name", "contact_no", "image_name", "image_name_old", "imageData", "session_kill","active"];
foreach ($required_fields as $field) {
    if (!isset($_POST[$field])) {
        echo json_encode(["success" => "false", "error" => "$field is missing"]);
        exit;
    }
}

$user_id = $_POST["user_id"];
$user_name = $_POST["user_name"];
$contact_no = $_POST["contact_no"];
$image_name = $_POST["image_name"];
$image_name_old = $_POST["image_name_old"];
$imageData = $_POST["imageData"];
$session_kill = $_POST["session_kill"];
$active = $_POST["active"];

$path = "../image/profile_image/$image_name";
$oldPath = "../image/profile_image/$image_name_old";

// Prepared statement to prevent SQL injection
$stmt = $con->prepare("UPDATE user_info SET user_name = ?, contact_no = ?, image_name = ?, update_date = NOW(), session_kill = ?, active = ? WHERE user_id = ?");
$stmt->bind_param("sssiis", $user_name, $contact_no, $image_name, $session_kill, $active,$user_id);

$response = [];

if ($stmt->execute()) {
    // Handle image only if new image data is sent
    if (!empty($imageData)) {
        if (file_exists($oldPath)) {
            unlink($oldPath);
        }
        if (file_put_contents($path, base64_decode($imageData))) {
            $response["success"] = "true";
        } else {
            $response["success"] = "false";
            $response["error"] = "Failed to save new image.";
        }
    } else {
        $response["success"] = "true";
    }
} else {
    $response["success"] = "false";
    $response["error"] = "Database update failed.";
}

echo json_encode($response);
?>
